var SpriteLibrary = [
    { filename: "ship_1.png", name: "Ship_1", index: 0, scale: 0.8 },
    { filename: "ship_2.png", name: "Ship_1", index: 1, scale: 0.8 },
    { filename: "ship_3.png", name: "Ship_1", index: 2, scale: 0.8 },
    { filename: "Schaufel.png", name: "Werkzeug", index: 0, scale: 1.0 },
    { filename: "minesweeper/minesweeper.png", name: "Minesweeper", tilesX: 20, tilesY: 1, spacingX: 1, scale: 1.0, index: 0 },
    { filename: "minesweeper/minesweeper-numbers.png", name: "Minesweeper", tilesX: 10, tilesY: 1, scale: 1.0, index: 22 },
    // Sleepy Blocks
    { filename: "Sleepy_Blocks/sleepy_blocks.png", name: "Sleepy_Blocks", tilesX: 5, tilesY: 1, spacingX: 2, spacingY: 2, scale: 1.0, index: 0, extrudeMarginWidth: 1 },
    { filename: "flappy_bird/bird1.png", name: "Bird", index: 0, indexName: "Bird" },
    { filename: "flappy_bird/bird2.png", name: "Bird", index: 1, indexName: "Bird" },
    { filename: "flappy_bird/bird3.png", name: "Bird", index: 2, indexName: "Bird" },
    { filename: "flappy_bird/Baeume.png", name: "Bird", index: 3, indexName: "Bird" },
    { filename: "flappy_bird/houses.png", name: "Bird", index: 4, indexName: "Bird" },
    { filename: "flappy_bird/Leiste.png", name: "Bird", index: 5, indexName: "Bird" },
    { filename: "flappy_bird/Saeule.png", name: "Bird", index: 6, indexName: "Bird" },
    { filename: "flappy_bird/Wolken.png", name: "Bird", index: 7, indexName: "Bird" },
    { filename: "Raumschiff_Adrian/NeuesRaumschiff/raumschiff_0004_geradeaus.png", name: "Space_Shooter_1", index: 0 },
    { filename: "Raumschiff_Adrian/NeuesRaumschiff/raumschiff_0001_runter1.png", name: "Space_Shooter_1", index: 1 },
    { filename: "Raumschiff_Adrian/NeuesRaumschiff/raumschiff_0000_runter2.png", name: "Space_Shooter_1", index: 2 },
    { filename: "Raumschiff_Adrian/NeuesRaumschiff/raumschiff_0003_hoch1.png", name: "Space_Shooter_1", index: 3 },
    { filename: "Raumschiff_Adrian/NeuesRaumschiff/raumschiff_0002_hoch2.png", name: "Space_Shooter_1", index: 4 },
    { filename: "Raumschiff_Adrian/NeuerSchuss.png", name: "Space_Shooter_1", index: 5 },
    { filename: "Raumschiff_Adrian/Schussanimation/schuss_0000.png", name: "Space_Shooter_1", index: 6 },
    { filename: "Raumschiff_Adrian/Schussanimation/schuss_0001.png", name: "Space_Shooter_1", index: 7 },
    { filename: "Raumschiff_Adrian/Schussanimation/schuss_0002.png", name: "Space_Shooter_1", index: 8 },
    { filename: "Raumschiff_Adrian/Schussanimation/schuss_0003.png", name: "Space_Shooter_1", index: 9 },
    { filename: "Raumschiff_Adrian/Asteroid.png", name: "Space_Shooter_1", index: 10 },
    { filename: "Raumschiff_Adrian/Gegner.png", name: "Space_Shooter_1", index: 11 },
    { filename: "Raumschiff_Adrian/Explosion/explosion_0000_..png", name: "Space_Shooter_1", index: 12 },
    { filename: "Raumschiff_Adrian/Explosion/explosion_0001_..png", name: "Space_Shooter_1", index: 13 },
    { filename: "Raumschiff_Adrian/Explosion/explosion_0002_..png", name: "Space_Shooter_1", index: 14 },
    { filename: "Raumschiff_Adrian/Explosion/explosion_0003_..png", name: "Space_Shooter_1", index: 15 },
    { filename: "Raumschiff_Adrian/Explosion/explosion_0004_..png", name: "Space_Shooter_1", index: 16 },
    { filename: "Raumschiff_Adrian/Explosion/explosion_0005_..png", name: "Space_Shooter_1", index: 17 },
    { filename: "Raumschiff_Adrian/Explosion/explosion_0006_..png", name: "Space_Shooter_1", index: 18 },
    { filename: "Raumschiff_Adrian/Explosion/explosion_0007_..png", name: "Space_Shooter_1", index: 19 },
    { filename: "Raumschiff_Adrian/Explosion/explosion_0008_..png", name: "Space_Shooter_1", index: 20 },
    { filename: "Raumschiff_Adrian/Explosion/explosion_0009_..png", name: "Space_Shooter_1", index: 21 },
    { filename: "Raumschiff_Adrian/Explosion/explosion_0010_..png", name: "Space_Shooter_1", index: 22 },
    { filename: "Raumschiff_Adrian/Explosion/explosion_0011_..png", name: "Space_Shooter_1", index: 23 },
    // Spaceshooter 2
    { filename: "classics/spaceship_1.png", name: "Space_Shooter_2", index: 0 },
    { filename: "classics/spaceship_2.png", name: "Space_Shooter_2", index: 1 },
    { filename: "classics/spaceship_3.png", name: "Space_Shooter_2", index: 2 },
    { filename: "classics/spaceship_4.png", name: "Space_Shooter_2", index: 3 },
    { filename: "classics/spaceship_5.png", name: "Space_Shooter_2", index: 4 },
    { filename: "classics/spaceship_6.png", name: "Space_Shooter_2", index: 5 },
    { filename: "classics/spaceship_7.png", name: "Space_Shooter_2", index: 6 },
    { filename: "classics/spaceship_8.png", name: "Space_Shooter_2", index: 7 },
    { filename: "classics/spaceship_9.png", name: "Space_Shooter_2", index: 8 },
    { filename: "classics/missile_1.png", name: "Space_Shooter_2", index: 9 },
    { filename: "classics/missile_2.png", name: "Space_Shooter_2", index: 10 },
    { filename: "classics/missile_3.png", name: "Space_Shooter_2", index: 11 },
    { filename: "classics/missile_4.png", name: "Space_Shooter_2", index: 12 },
    { filename: "classics/missile_5.png", name: "Space_Shooter_2", index: 13 },
    { filename: "classics/missile_6.png", name: "Space_Shooter_2", index: 14 },
    { filename: "classics/missile_7.png", name: "Space_Shooter_2", index: 15 },
    { filename: "classics/missile_8.png", name: "Space_Shooter_2", index: 16 },
    { filename: "classics/missile_9.png", name: "Space_Shooter_2", index: 17 },
    { filename: "classics/missile_10.png", name: "Space_Shooter_2", index: 18 },
    { filename: "classics/missile_11.png", name: "Space_Shooter_2", index: 19 },
    { filename: "classics/missile_12.png", name: "Space_Shooter_2", index: 20 },
    { filename: "classics/satellite_1.png", name: "Space_Shooter_2", index: 21 },
    { filename: "classics/satellite_2.png", name: "Space_Shooter_2", index: 22 },
    // Soko
    { filename: "classics/sokoban_man_horizontal.png", name: "Soko", tilesX: 3, tilesY: 1, spacingX: 2, spacingY: 0, scale: 1.0, index: 0, extrudeMarginWidth: 1 },
    { filename: "classics/sokoban_man_vertical.png", name: "Soko", tilesX: 6, tilesY: 1, spacingX: 2, spacingY: 0, scale: 1.0, index: 3, extrudeMarginWidth: 1 },
    { filename: "classics/sokoban_box_1.png", name: "Soko", index: 9, extrudeMarginWidth: 1 },
    { filename: "classics/sokoban_box_2.png", name: "Soko", index: 10, extrudeMarginWidth: 1 },
    { filename: "classics/sokoban_empty.png", name: "Soko", index: 11, extrudeMarginWidth: 1 },
    { filename: "classics/sokoban_wall.png", name: "Soko", index: 12, extrudeMarginWidth: 1 },
    { filename: "classics/sokoban_target.png", name: "Soko", index: 13, extrudeMarginWidth: 1 },
    // P-Man
    { filename: "classics/pacman_characters.png", name: "PMan", tilesX: 22, tilesY: 1, spacingX: 2, spacingY: 0, scale: 1.0, index: 0 },
    { filename: "classics/pacman_maze.png", name: "PMan", tilesX: 15, tilesY: 1, spacingX: 2, spacingY: 0, scale: 1.0, index: 22 },
    // Breakin
    { filename: "classics/bo_bat_long.png", name: "Breakin", index: 0 },
    { filename: "classics/bo_bat_short.png", name: "Breakin", index: 1 },
    { filename: "classics/bo_ball_blue.png", name: "Breakin", index: 2 },
    { filename: "classics/bo_ball_gray.png", name: "Breakin", index: 3 },
    { filename: "classics/bo_rechteck.png", name: "Breakin", index: 4 },
    { filename: "classics/bo_rechteck_active.png", name: "Breakin", index: 5 },
    { filename: "classics/bo_quadrat.png", name: "Breakin", index: 6 },
    { filename: "classics/bo_quadrat_active.png", name: "Breakin", index: 7 },
    { filename: "classics/bo_fuenfeck.png", name: "Breakin", index: 8 },
    { filename: "classics/bo_fuenfeck_active.png", name: "Breakin", index: 9 },
    { filename: "classics/bo_raute.png", name: "Breakin", index: 10 },
    { filename: "classics/bo_raute_active.png", name: "Breakin", index: 11 },
    { filename: "classics/bo_star1.png", name: "Breakin", index: 12 },
    { filename: "classics/bo_star2.png", name: "Breakin", index: 13 },
    // Chess
    // Source: https://commons.wikimedia.org/wiki/Category:SVG_chess_pieces
    { filename: "classics/Chess.png", name: "Boardgames", tilesX: 6, tilesY: 2, spacingX: 2, spacingY: 2, scale: 1.0, index: 0 },
    { filename: "classics/Spielstein.png", name: "Boardgames", index: 12 },
    { filename: "classics/wuerfel_1.png", name: "Boardgames", index: 13 },
    { filename: "classics/wuerfel_2.png", name: "Boardgames", index: 14 },
    { filename: "classics/wuerfel_3.png", name: "Boardgames", index: 15 },
    { filename: "classics/wuerfel_4.png", name: "Boardgames", index: 16 },
    { filename: "classics/wuerfel_5.png", name: "Boardgames", index: 17 },
    { filename: "classics/wuerfel_6.png", name: "Boardgames", index: 18 },
    // Platformer
    { filename: "plattformer/Tiles_and_enemies_64x64.png", name: "Plattforms", tilesX: 22, tilesY: 16, spacingX: 2, spacingY: 2, scale: 1.0, index: 0, extrudeMarginWidth: 1 },
    // Tower defense
    { filename: "tower-defense/tower-defense.png", name: "TowerDefense", tilesX: 18, tilesY: 10, spacingX: 2, spacingY: 2, scale: 1.0, index: 0, extrudeMarginWidth: 1 },
    // Platformer character
    { filename: "plattformer/male.png", name: "Characters_1", tilesX: 6, tilesY: 2, spacingX: 0, spacingY: 0, scale: 1.0, index: 0 },
    // {filename: "plattformer/female.png", name: "Characters", tilesX: 6, tilesY: 2, spacingX: 0, spacingY: 0, scale: 1.0, index: 12},
    { filename: "plattformer/background_grass.png", name: "Background", index: 0, scale: 0.2 },
    { filename: "plattformer/background_mountains.png", name: "Background", index: 1, scale: 0.2 },
    { filename: "plattformer/background_sky.png", name: "Background", index: 2, scale: 0.2 },
    { filename: "plattformer/cloud1.png", name: "Background", index: 3, scale: 0.5 },
    { filename: "plattformer/cloud2.png", name: "Background", index: 4, scale: 0.5 },
    { filename: "plattformer/cloud3.png", name: "Background", index: 5, scale: 0.5 },
    { filename: "plattformer/cloud4.png", name: "Background", index: 6, scale: 0.5 },
    { filename: "plattformer/grass1.png", name: "Background", index: 7 },
    { filename: "plattformer/grass2.png", name: "Background", index: 8 },
    { filename: "plattformer/grass3.png", name: "Background", index: 9 },
    { filename: "plattformer/tree1.png", name: "Background", index: 10, scale: 0.5 },
    { filename: "plattformer/tree2.png", name: "Background", index: 11, scale: 0.5 },
    { filename: "plattformer/tree3.png", name: "Background", index: 12, scale: 0.5 },
];
function expandDigits(n, digits) {
    let s = "" + n;
    while (s.length < digits)
        s = "0" + s;
    return s;
}
let spriteLibInit = () => {
    for (let i = 0; i < 56; i++) {
        SpriteLibrary.push({
            filename: "explosion-images/explosion" + expandDigits(i, 4) + ".png",
            name: "Explosion_1",
            index: i
        });
    }
    for (let i = 1; i <= 10; i++) {
        SpriteLibrary.push({
            filename: "boulders/image_part_" + expandDigits(i, 3) + ".png",
            name: "Boulders",
            index: i - 1
        });
    }
};
spriteLibInit();
if (typeof module != "undefined") {
    module.exports = SpriteLibrary;
}
//# sourceMappingURL=data:application/json;base64,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